﻿# --------------------------------------------------------------------------------
# LOKÁLIS PROFIL TÖRLŐ SCRIPT SMEITHu (PowerShell)
# Használat: Futtatás ELŐTT a felhasználó legyen KIJELENTKEZVE a gépről!
# --------------------------------------------------------------------------------

# Állítsd be a célnévre (a felhasználó Windows/Domain felhasználóneve)
# FELHASZNÁLÓ NEVE: Gipsz Jakab
$TargetUser = "gipsz.jakab" # <--- EZ A VÁLTOZÓ FRISSÍTVE

Write-Host "Keresem a lokális profilt a(z) '$TargetUser' felhasználóhoz..." -ForegroundColor Yellow

# 1. Megkeresi a felhasználó SID-jét és a profil útvonalát a Registry-ben
$ProfileKey = Get-ChildItem -Path "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\ProfileList" | Where-Object {
    $_.GetValue("ProfileImagePath") -like "*\$TargetUser"
}

if ($ProfileKey -eq $null) {
    Write-Host "Hiba: A felhasználó ('$TargetUser') lokális profilja nem található a Registryben." -ForegroundColor Red
    Write-Host "A script leáll." -ForegroundColor Red
}
else {
    $SID = $ProfileKey.PSChildName
    $ProfilePath = $ProfileKey.GetValue("ProfileImagePath")

    Write-Host "Azonosított SID: $SID" -ForegroundColor Green
    Write-Host "Azonosított lokális útvonal: $ProfilePath" -ForegroundColor Green
    
    # 2. Eltávolítja a Registry kulcsot
    Write-Host "Törlöm a Registry kulcsot..." -ForegroundColor Yellow
    Remove-Item -Path "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\ProfileList\$SID" -Force -Confirm:$false
    
    # 3. Törli a C:\Users alatti mappát
    Write-Host "Törlöm a fizikai mappát: $ProfilePath ..." -ForegroundColor Yellow
    
    # Fontos ellenőrzés: Csak a C:\Users alatti mappát törölje!
    if ($ProfilePath -like "C:\Users\*") {
        # 'Force' és 'Recurse' kell a teljes tartalom törléséhez
        Remove-Item -Path $ProfilePath -Recurse -Force -Confirm:$false
        Write-Host "Sikeresen eltávolítva: $TargetUser lokális profilja." -ForegroundColor Green
    }
    else {
        Write-Host "Figyelem: Az útvonal ('$ProfilePath') nem a C:\Users mappában van. A fizikai törlés kimaradt." -ForegroundColor Red
    }
}

Write-Host "A folyamat befejeződött. Kérd meg a felhasználót a bejelentkezésre." -ForegroundColor Cyan
# Futtassuk a GPO frissítést is, biztos ami biztos
gpupdate /force